/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.tap.org.mariuszgromada.math.mxparser.mathcollection;

import com.github.monun.survival.tap.org.mariuszgromada.math.mxparser.mXparser;
import com.github.monun.survival.tap.org.mariuszgromada.math.mxparser.mathcollection.Coefficients;
import com.github.monun.survival.tap.org.mariuszgromada.math.mxparser.mathcollection.Evaluate;
import com.github.monun.survival.tap.org.mariuszgromada.math.mxparser.mathcollection.MathConstants;
import com.github.monun.survival.tap.org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;

public final class SpecialFunctions {
    private static final double EI_DBL_EPSILON = Math.ulp(1.0);
    private static final double EI_EPSILON = 10.0 * EI_DBL_EPSILON;
    private static final int doubleWidth = 53;
    private static final double doublePrecision = Math.pow(2.0, -53.0);
    private static final double GSL_DBL_EPSILON = 2.220446049250313E-16;

    public static double exponentialIntegralEi(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x < -5.0) {
            return SpecialFunctions.continuedFractionEi(x);
        }
        if (x == 0.0) {
            return -1.7976931348623157E308;
        }
        if (x < 6.8) {
            return SpecialFunctions.powerSeriesEi(x);
        }
        if (x < 50.0) {
            return SpecialFunctions.argumentAdditionSeriesEi(x);
        }
        return SpecialFunctions.continuedFractionEi(x);
    }

    private static double continuedFractionEi(double x) {
        double Am1 = 1.0;
        double A0 = 0.0;
        double Bm1 = 0.0;
        double B0 = 1.0;
        double a = Math.exp(x);
        double b = -x + 1.0;
        double Ap1 = b * A0 + a * Am1;
        double Bp1 = b * B0 + a * Bm1;
        int j = 1;
        a = 1.0;
        while (Math.abs(Ap1 * B0 - A0 * Bp1) > EI_EPSILON * Math.abs(A0 * Bp1)) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            if (Math.abs(Bp1) > 1.0) {
                Am1 = A0 / Bp1;
                A0 = Ap1 / Bp1;
                Bm1 = B0 / Bp1;
                B0 = 1.0;
            } else {
                Am1 = A0;
                A0 = Ap1;
                Bm1 = B0;
                B0 = Bp1;
            }
            a = -j * j;
            Ap1 = (b += 2.0) * A0 + a * Am1;
            Bp1 = b * B0 + a * Bm1;
            ++j;
        }
        return -Ap1 / Bp1;
    }

    private static double powerSeriesEi(double x) {
        double xn = -x;
        double Sn = -x;
        double Sm1 = 0.0;
        double hsum = 1.0;
        double g = 0.5772156649015329;
        double y = 1.0;
        double factorial = 1.0;
        if (x == 0.0) {
            return -1.7976931348623157E308;
        }
        while (Math.abs(Sn - Sm1) > EI_EPSILON * Math.abs(Sm1)) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            Sm1 = Sn;
            Sn += (hsum += 1.0 / y) * (xn *= -x) / (factorial *= (y += 1.0));
        }
        return 0.5772156649015329 + Math.log(Math.abs(x)) - Math.exp(x) * Sn;
    }

    private static double argumentAdditionSeriesEi(double x) {
        int k = (int)(x + 0.5);
        int j = 0;
        double xx = k;
        double dx = x - xx;
        double xxj = xx;
        double edx = Math.exp(dx);
        double Sm = 1.0;
        double Sn = (edx - 1.0) / xxj;
        double term = Double.MAX_VALUE;
        double factorial = 1.0;
        double dxj = 1.0;
        while (Math.abs(term) > EI_EPSILON * Math.abs(Sn)) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            term = factorial * (edx * (Sm += (dxj *= -dx) / (factorial *= (double)(++j))) - 1.0) / (xxj *= xx);
            Sn += term;
        }
        return Coefficients.EI[k - 7] + Sn * Math.exp(xx);
    }

    public static final double logarithmicIntegralLi(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 2.0) {
            return 1.045163780117493;
        }
        return SpecialFunctions.exponentialIntegralEi(MathFunctions.ln(x));
    }

    public static final double offsetLogarithmicIntegralLi(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return -1.045163780117493;
        }
        return SpecialFunctions.logarithmicIntegralLi(x) - 1.045163780117493;
    }

    public static final double erf(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return -1.0;
        }
        return SpecialFunctions.erfImp(x, false);
    }

    public static final double erfc(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 1.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 2.0;
        }
        return SpecialFunctions.erfImp(x, true);
    }

    public static final double erfInv(double x) {
        double s;
        double q;
        double p;
        if (x == 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (x <= -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x < 0.0) {
            p = -x;
            q = 1.0 - p;
            s = -1.0;
        } else {
            p = x;
            q = 1.0 - x;
            s = 1.0;
        }
        return SpecialFunctions.erfInvImpl(p, q, s);
    }

    private static final double erfImp(double z, boolean invert) {
        double result;
        if (z < 0.0) {
            if (!invert) {
                return -SpecialFunctions.erfImp(-z, false);
            }
            if (z < -0.5) {
                return 2.0 - SpecialFunctions.erfImp(-z, true);
            }
            return 1.0 + SpecialFunctions.erfImp(-z, false);
        }
        if (z < 0.5) {
            result = z < 1.0E-10 ? z * 1.125 + z * 0.0033791670955125737 : z * 1.125 + z * Evaluate.polynomial(z, Coefficients.erfImpAn) / Evaluate.polynomial(z, Coefficients.erfImpAd);
        } else if (z < 110.0 || z < 110.0 && invert) {
            double b;
            double r;
            boolean bl = invert = !invert;
            if (z < 0.75) {
                r = Evaluate.polynomial(z - 0.5, Coefficients.erfImpBn) / Evaluate.polynomial(z - 0.5, Coefficients.erfImpBd);
                b = 0.3440242111682892;
            } else if (z < 1.25) {
                r = Evaluate.polynomial(z - 0.75, Coefficients.erfImpCn) / Evaluate.polynomial(z - 0.75, Coefficients.erfImpCd);
                b = 0.4199909269809723;
            } else if (z < 2.25) {
                r = Evaluate.polynomial(z - 1.25, Coefficients.erfImpDn) / Evaluate.polynomial(z - 1.25, Coefficients.erfImpDd);
                b = 0.4898625f;
            } else if (z < 3.5) {
                r = Evaluate.polynomial(z - 2.25, Coefficients.erfImpEn) / Evaluate.polynomial(z - 2.25, Coefficients.erfImpEd);
                b = 0.5317370891571045;
            } else if (z < 5.25) {
                r = Evaluate.polynomial(z - 3.5, Coefficients.erfImpFn) / Evaluate.polynomial(z - 3.5, Coefficients.erfImpFd);
                b = 0.5489973425865173;
            } else if (z < 8.0) {
                r = Evaluate.polynomial(z - 5.25, Coefficients.erfImpGn) / Evaluate.polynomial(z - 5.25, Coefficients.erfImpGd);
                b = 0.5571740865707397;
            } else if (z < 11.5) {
                r = Evaluate.polynomial(z - 8.0, Coefficients.erfImpHn) / Evaluate.polynomial(z - 8.0, Coefficients.erfImpHd);
                b = 0.5609807968139648;
            } else if (z < 17.0) {
                r = Evaluate.polynomial(z - 11.5, Coefficients.erfImpIn) / Evaluate.polynomial(z - 11.5, Coefficients.erfImpId);
                b = 0.5626493692398071;
            } else if (z < 24.0) {
                r = Evaluate.polynomial(z - 17.0, Coefficients.erfImpJn) / Evaluate.polynomial(z - 17.0, Coefficients.erfImpJd);
                b = 0.5634598135948181;
            } else if (z < 38.0) {
                r = Evaluate.polynomial(z - 24.0, Coefficients.erfImpKn) / Evaluate.polynomial(z - 24.0, Coefficients.erfImpKd);
                b = 0.5638477802276611;
            } else if (z < 60.0) {
                r = Evaluate.polynomial(z - 38.0, Coefficients.erfImpLn) / Evaluate.polynomial(z - 38.0, Coefficients.erfImpLd);
                b = 0.5640528202056885;
            } else if (z < 85.0) {
                r = Evaluate.polynomial(z - 60.0, Coefficients.erfImpMn) / Evaluate.polynomial(z - 60.0, Coefficients.erfImpMd);
                b = 0.5641309022903442;
            } else {
                r = Evaluate.polynomial(z - 85.0, Coefficients.erfImpNn) / Evaluate.polynomial(z - 85.0, Coefficients.erfImpNd);
                b = 0.5641584396362305;
            }
            double g = MathFunctions.exp(-z * z) / z;
            result = g * b + g * r;
        } else {
            result = 0.0;
            boolean bl = invert = !invert;
        }
        if (invert) {
            result = 1.0 - result;
        }
        return result;
    }

    public static final double erfcInv(double z) {
        double s;
        double p;
        double q;
        if (z <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (z >= 2.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (z > 1.0) {
            q = 2.0 - z;
            p = 1.0 - q;
            s = -1.0;
        } else {
            p = 1.0 - z;
            q = z;
            s = 1.0;
        }
        return SpecialFunctions.erfInvImpl(p, q, s);
    }

    private static final double erfInvImpl(double p, double q, double s) {
        double result;
        if (p <= 0.5) {
            float y = 0.089131474f;
            double g = p * (p + 10.0);
            double r = Evaluate.polynomial(p, Coefficients.ervInvImpAn) / Evaluate.polynomial(p, Coefficients.ervInvImpAd);
            result = g * 0.08913147449493408 + g * r;
        } else if (q >= 0.25) {
            float y = 2.2494812f;
            double g = MathFunctions.sqrt(-2.0 * MathFunctions.ln(q));
            double xs = q - 0.25;
            double r = Evaluate.polynomial(xs, Coefficients.ervInvImpBn) / Evaluate.polynomial(xs, Coefficients.ervInvImpBd);
            result = g / (2.249481201171875 + r);
        } else {
            double x = MathFunctions.sqrt(-MathFunctions.ln(q));
            if (x < 3.0) {
                float y = 0.80722046f;
                double xs = x - 1.125;
                double r = Evaluate.polynomial(xs, Coefficients.ervInvImpCn) / Evaluate.polynomial(xs, Coefficients.ervInvImpCd);
                result = 0.807220458984375 * x + r * x;
            } else if (x < 6.0) {
                float y = 0.9399557f;
                double xs = x - 3.0;
                double r = Evaluate.polynomial(xs, Coefficients.ervInvImpDn) / Evaluate.polynomial(xs, Coefficients.ervInvImpDd);
                result = 0.9399557113647461 * x + r * x;
            } else if (x < 18.0) {
                float y = 0.9836283f;
                double xs = x - 6.0;
                double r = Evaluate.polynomial(xs, Coefficients.ervInvImpEn) / Evaluate.polynomial(xs, Coefficients.ervInvImpEd);
                result = 0.9836282730102539 * x + r * x;
            } else if (x < 44.0) {
                float y = 0.99714565f;
                double xs = x - 18.0;
                double r = Evaluate.polynomial(xs, Coefficients.ervInvImpFn) / Evaluate.polynomial(xs, Coefficients.ervInvImpFd);
                result = 0.9971456527709961 * x + r * x;
            } else {
                float y = 0.9994135f;
                double xs = x - 44.0;
                double r = Evaluate.polynomial(xs, Coefficients.ervInvImpGn) / Evaluate.polynomial(xs, Coefficients.ervInvImpGd);
                result = 0.9994134902954102 * x + r * x;
            }
        }
        return s * result;
    }

    private static final double gammaInt(long n) {
        if (n == 0L) {
            return 0.5772156649015329;
        }
        if (n == 1L) {
            return 1.0;
        }
        if (n == 2L) {
            return 1.0;
        }
        if (n == 3L) {
            return 2.0;
        }
        if (n == 4L) {
            return 6.0;
        }
        if (n == 5L) {
            return 24.0;
        }
        if (n == 6L) {
            return 120.0;
        }
        if (n == 7L) {
            return 720.0;
        }
        if (n == 8L) {
            return 5040.0;
        }
        if (n == 9L) {
            return 40320.0;
        }
        if (n == 10L) {
            return 362880.0;
        }
        if (n >= 11L) {
            return MathFunctions.factorial(n - 1L);
        }
        if (n <= -1L) {
            long r = -n;
            double factr = MathFunctions.factorial(r);
            double sign = -1.0;
            if (r % 2L == 0L) {
                sign = 1.0;
            }
            return sign / ((double)r * factr) - 1.0 / (double)r * SpecialFunctions.gammaInt(n + 1L);
        }
        return Double.NaN;
    }

    public static final double gamma(double x) {
        double xint;
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        double xabs = MathFunctions.abs(x);
        if (MathFunctions.abs(xabs - (xint = (double)Math.round(xabs))) <= 1.0E-14) {
            long n = (long)xint;
            if (x < 0.0) {
                n = -n;
            }
            return SpecialFunctions.gammaInt(n);
        }
        return SpecialFunctions.lanchosGamma(x);
    }

    public static final double lanchosGamma(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        double xabs = MathFunctions.abs(x);
        double xint = Math.round(xabs);
        if (x > 1.0E-14) {
            if (MathFunctions.abs(xabs - xint) <= 1.0E-14) {
                return MathFunctions.factorial(xint - 1.0);
            }
        } else if (x < -1.0E-14) {
            if (MathFunctions.abs(xabs - xint) <= 1.0E-14) {
                return Double.NaN;
            }
        } else {
            return Double.NaN;
        }
        if (x < 0.5) {
            return Math.PI / (Math.sin(Math.PI * x) * SpecialFunctions.lanchosGamma(1.0 - x));
        }
        int g = 7;
        double a = Coefficients.lanchosGamma[0];
        double t = (x -= 1.0) + (double)g + 0.5;
        for (int i = 1; i < Coefficients.lanchosGamma.length; ++i) {
            a += Coefficients.lanchosGamma[i] / (x + (double)i);
        }
        return Math.sqrt(Math.PI * 2) * Math.pow(t, x + 0.5) * Math.exp(-t) * a;
    }

    public static double logGamma(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        if (MathFunctions.isInteger(x)) {
            if (x >= 0.0) {
                return Math.log(Math.abs(SpecialFunctions.gammaInt(Math.round(x))));
            }
            return Math.log(Math.abs(SpecialFunctions.gammaInt(-Math.round(-x))));
        }
        if (x < -34.0) {
            double q = -x;
            double w = SpecialFunctions.logGamma(q);
            double p = Math.floor(q);
            if (Math.abs(p - q) <= 1.0E-14) {
                return Double.NaN;
            }
            double z = q - p;
            if (z > 0.5) {
                z = (p += 1.0) - q;
            }
            if (Math.abs(z = q * Math.sin(Math.PI * z)) <= 1.0E-14) {
                return Double.NaN;
            }
            z = MathConstants.LNPI - Math.log(z) - w;
            return z;
        }
        if (x < 13.0) {
            double z = 1.0;
            while (x >= 3.0) {
                z *= (x -= 1.0);
            }
            while (x < 2.0) {
                if (Math.abs(x) <= 1.0E-14) {
                    return Double.NaN;
                }
                z /= x;
                x += 1.0;
            }
            if (z < 0.0) {
                z = -z;
            }
            if (x == 2.0) {
                return Math.log(z);
            }
            double p = (x -= 2.0) * Evaluate.polevl(x, Coefficients.logGammaB, 5) / Evaluate.p1evl(x, Coefficients.logGammaC, 6);
            return Math.log(z) + p;
        }
        if (x > 2.556348E305) {
            return Double.NaN;
        }
        double q = (x - 0.5) * Math.log(x) - x + 0.9189385332046728;
        if (x > 1.0E8) {
            return q;
        }
        double p = 1.0 / (x * x);
        q = x >= 1000.0 ? (q += ((7.936507936507937E-4 * p - 0.002777777777777778) * p + 0.08333333333333333) / x) : (q += Evaluate.polevl(p, Coefficients.logGammaA, 4) / x);
        return q;
    }

    public static final double sgnGamma(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        if (x > 0.0) {
            return 1.0;
        }
        if (MathFunctions.isInteger(x)) {
            return MathFunctions.sgn(SpecialFunctions.gammaInt(-Math.round(-x)));
        }
        double fx = Math.floor(x = -x);
        double div2remainder = Math.floor(fx % 2.0);
        if (div2remainder == 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static final double regularizedGammaLowerP(double s, double x) {
        double error;
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(s)) {
            return Double.NaN;
        }
        if (MathFunctions.almostEqual(x, 0.0)) {
            return 0.0;
        }
        if (MathFunctions.almostEqual(s, 0.0)) {
            return 1.0 + SpecialFunctions.exponentialIntegralEi(-x) / 0.5772156649015329;
        }
        if (MathFunctions.almostEqual(s, 1.0)) {
            return 1.0 - Math.exp(-x);
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        if (s < 0.0) {
            return SpecialFunctions.regularizedGammaLowerP(s + 1.0, x) + Math.pow(x, s) * Math.exp(-x) / (s * SpecialFunctions.gamma(s));
        }
        double epsilon = 1.0E-15;
        double bigNumber = 4.503599627370496E15;
        double bigNumberInverse = 2.220446049250313E-16;
        double ax = s * Math.log(x) - x - SpecialFunctions.logGamma(s);
        if (ax < -709.782712893384) {
            return 1.0;
        }
        if (x <= 1.0 || x <= s) {
            double r2 = s;
            double c2 = 1.0;
            double ans2 = 1.0;
            while ((c2 = c2 * x / (r2 += 1.0)) / (ans2 += c2) > 1.0E-15) {
            }
            return Math.exp(ax) * ans2 / s;
        }
        int c = 0;
        double y = 1.0 - s;
        double z = x + y + 1.0;
        double p3 = 1.0;
        double q3 = x;
        double p2 = x + 1.0;
        double q2 = z * x;
        double ans = p2 / q2;
        do {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            double yc = (y += 1.0) * (double)(++c);
            double p = p2 * (z += 2.0) - p3 * yc;
            double q = q2 * z - q3 * yc;
            if (q != 0.0) {
                double nextans = p / q;
                error = Math.abs((ans - nextans) / nextans);
                ans = nextans;
            } else {
                error = 1.0;
            }
            p3 = p2;
            p2 = p;
            q3 = q2;
            q2 = q;
            if (!(Math.abs(p) > 4.503599627370496E15)) continue;
            p3 *= 2.220446049250313E-16;
            p2 *= 2.220446049250313E-16;
            q3 *= 2.220446049250313E-16;
            q2 *= 2.220446049250313E-16;
        } while (error > 1.0E-15);
        return 1.0 - Math.exp(ax) * ans;
    }

    public static final double incompleteGammaLower(double s, double x) {
        return SpecialFunctions.gamma(s) * SpecialFunctions.regularizedGammaLowerP(s, x);
    }

    public static final double regularizedGammaUpperQ(double s, double x) {
        double t;
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(s)) {
            return Double.NaN;
        }
        if (MathFunctions.almostEqual(x, 0.0)) {
            return 1.0;
        }
        if (MathFunctions.almostEqual(s, 0.0)) {
            return -SpecialFunctions.exponentialIntegralEi(-x) / 0.5772156649015329;
        }
        if (MathFunctions.almostEqual(s, 1.0)) {
            return Math.exp(-x);
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        if (s < 0.0) {
            return SpecialFunctions.regularizedGammaUpperQ(s + 1.0, x) - Math.pow(x, s) * Math.exp(-x) / (s * SpecialFunctions.gamma(s));
        }
        double ax = s * Math.log(x) - x - SpecialFunctions.logGamma(s);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        double igammaepsilon = 1.0E-15;
        double igammabignumber = 4.503599627370496E15;
        double igammabignumberinv = 2.220446049250313E-16;
        ax = Math.exp(ax);
        double y = 1.0 - s;
        double z = x + y + 1.0;
        double c = 0.0;
        double pkm2 = 1.0;
        double qkm2 = x;
        double pkm1 = x + 1.0;
        double qkm1 = z * x;
        double ans = pkm1 / qkm1;
        do {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            double yc = (y += 1.0) * (c += 1.0);
            double pk = pkm1 * (z += 2.0) - pkm2 * yc;
            double qk = qkm1 * z - qkm2 * yc;
            if (qk != 0.0) {
                double r = pk / qk;
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (!(Math.abs(pk) > 4.503599627370496E15)) continue;
            pkm2 *= 2.220446049250313E-16;
            pkm1 *= 2.220446049250313E-16;
            qkm2 *= 2.220446049250313E-16;
            qkm1 *= 2.220446049250313E-16;
        } while (t > 1.0E-15);
        return ans * ax;
    }

    public static final double incompleteGammaUpper(double s, double x) {
        return SpecialFunctions.gamma(s) * SpecialFunctions.regularizedGammaUpperQ(s, x);
    }

    public static final double diGamma(double x) {
        double c = 12.0;
        double d1 = -0.5772156649015329;
        double d2 = 1.6449340668482264;
        double s = 1.0E-6;
        double s3 = 0.08333333333333333;
        double s4 = 0.008333333333333333;
        double s5 = 0.003968253968253968;
        double s6 = 0.004166666666666667;
        double s7 = 0.007575757575757576;
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        if (x <= 0.0 && MathFunctions.isInteger(x)) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return SpecialFunctions.diGamma(1.0 - x) + Math.PI / Math.tan(-Math.PI * x);
        }
        if (x <= 1.0E-6) {
            return -0.5772156649015329 - 1.0 / x + 1.6449340668482264 * x;
        }
        double result = 0.0;
        while (x < 12.0) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            result -= 1.0 / x;
            x += 1.0;
        }
        if (x >= 12.0) {
            double r = 1.0 / x;
            result += Math.log(x) - 0.5 * r;
            r *= r;
            result -= r * (0.08333333333333333 - r * (0.008333333333333333 - r * (0.003968253968253968 - r * (0.004166666666666667 - r * 0.007575757575757576))));
        }
        return result;
    }

    public static double logBeta(double x, double y) {
        double lgy;
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(y)) {
            return Double.NaN;
        }
        if (x <= 0.0 || y <= 0.0) {
            return Double.NaN;
        }
        double lgx = SpecialFunctions.logGamma(x);
        if (Double.isNaN(lgx)) {
            lgx = Math.log(Math.abs(SpecialFunctions.gamma(x)));
        }
        if (Double.isNaN(lgy = SpecialFunctions.logGamma(y))) {
            lgy = Math.log(Math.abs(SpecialFunctions.gamma(y)));
        }
        double lgxy = SpecialFunctions.logGamma(x + y);
        if (Double.isNaN(lgy)) {
            lgxy = Math.log(Math.abs(SpecialFunctions.gamma(x + y)));
        }
        if (!(Double.isNaN(lgx) || Double.isNaN(lgy) || Double.isNaN(lgxy))) {
            return lgx + lgy - lgxy;
        }
        return Double.NaN;
    }

    public static double beta(double x, double y) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(y)) {
            return Double.NaN;
        }
        if (x <= 0.0 || y <= 0.0) {
            return Double.NaN;
        }
        if (x > 99.0 || y > 99.0) {
            return Math.exp(SpecialFunctions.logBeta(x, y));
        }
        return SpecialFunctions.gamma(x) * SpecialFunctions.gamma(y) / SpecialFunctions.gamma(x + y);
    }

    public static double incompleteBeta(double a, double b, double x) {
        long n;
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x < -1.0E-14) {
            return Double.NaN;
        }
        if (x > 1.00000000000001) {
            return Double.NaN;
        }
        if (a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (MathFunctions.almostEqual(x, 0.0)) {
            return 0.0;
        }
        if (MathFunctions.almostEqual(x, 1.0)) {
            return SpecialFunctions.beta(a, b);
        }
        boolean aEq0 = MathFunctions.almostEqual(a, 0.0);
        boolean bEq0 = MathFunctions.almostEqual(b, 0.0);
        boolean aIsInt = MathFunctions.isInteger(a);
        boolean bIsInt = MathFunctions.isInteger(b);
        long aInt = 0L;
        long bInt = 0L;
        if (aIsInt) {
            aInt = (long)MathFunctions.integerPart(a);
        }
        if (bIsInt) {
            bInt = (long)MathFunctions.integerPart(b);
        }
        if (aEq0 && bEq0) {
            return Math.log(x / (1.0 - x));
        }
        if (aEq0 && bIsInt) {
            n = bInt;
            if (n >= 1L) {
                if (n == 1L) {
                    return Math.log(x);
                }
                if (n == 2L) {
                    return Math.log(x) + x;
                }
                double v = Math.log(x);
                for (long i = 1L; i <= n - 1L; ++i) {
                    v -= MathFunctions.binomCoeff((double)(n - 1L), i) * Math.pow(-1.0, i) * (Math.pow(x, i) / (double)i);
                }
                return v;
            }
            if (n <= -1L) {
                if (n == -1L) {
                    return Math.log(x / (1.0 - x)) + 1.0 / (1.0 - x) - 1.0;
                }
                if (n == -2L) {
                    return Math.log(x / (1.0 - x)) - 1.0 / x - 1.0 / (2.0 * x * x);
                }
                double v = -Math.log(x / (1.0 - x));
                for (long i = 1L; i <= -n - 1L; ++i) {
                    v -= Math.pow(x, -i) / (double)i;
                }
                return v;
            }
        }
        if (aIsInt && bEq0) {
            n = aInt;
            if (n >= 1L) {
                if (n == 1L) {
                    return -Math.log(1.0 - x);
                }
                if (n == 2L) {
                    return -Math.log(1.0 - x) - x;
                }
                double v = -Math.log(1.0 - x);
                for (long i = 1L; i <= n - 1L; ++i) {
                    v -= Math.pow(x, i) / (double)i;
                }
                return v;
            }
            if (n <= -1L) {
                long i;
                if (n == -1L) {
                    return Math.log(x / (1.0 - x)) - 1.0 / x;
                }
                double v = -Math.log(x / (1.0 - x));
                for (i = 1L; i <= -n; ++i) {
                    v += Math.pow(1.0 - x, -i) / (double)i;
                }
                for (i = 1L; i <= -n; ++i) {
                    v -= Math.pow(MathFunctions.factorial(i - 1L), 2.0) / (double)i;
                }
                return v;
            }
        }
        if (aIsInt) {
            n = aInt;
            if (MathFunctions.almostEqual(b, 1.0) && n <= -1L) {
                return (double)(-(1L / -n)) * Math.pow(x, n);
            }
        }
        return SpecialFunctions.regularizedBeta(a, b, x) * SpecialFunctions.beta(a, b);
    }

    public static double regularizedBeta(double a, double b, double x) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (x < -1.0E-14) {
            return Double.NaN;
        }
        if (x > 1.00000000000001) {
            return Double.NaN;
        }
        if (MathFunctions.almostEqual(x, 0.0)) {
            return 0.0;
        }
        if (MathFunctions.almostEqual(x, 1.0)) {
            return 1.0;
        }
        double bt = x == 0.0 || x == 1.0 ? 0.0 : Math.exp(SpecialFunctions.logGamma(a + b) - SpecialFunctions.logGamma(a) - SpecialFunctions.logGamma(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        boolean symmetryTransformation = x >= (a + 1.0) / (a + b + 2.0);
        double eps = doublePrecision;
        double fpmin = Math.nextUp(0.0) / eps;
        if (symmetryTransformation) {
            x = 1.0 - x;
            double swap = a;
            a = b;
            b = swap;
        }
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double c = 1.0;
        double d = 1.0 - qab * x / qap;
        if (Math.abs(d) < fpmin) {
            d = fpmin;
        }
        double h = d = 1.0 / d;
        int m = 1;
        int m2 = 2;
        while (m <= 50000) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            double aa = (double)m * (b - (double)m) * x / ((qam + (double)m2) * (a + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < fpmin) {
                d = fpmin;
            }
            if (Math.abs(c = 1.0 + aa / c) < fpmin) {
                c = fpmin;
            }
            d = 1.0 / d;
            h *= d * c;
            aa = -(a + (double)m) * (qab + (double)m) * x / ((a + (double)m2) * (qap + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < fpmin) {
                d = fpmin;
            }
            if (Math.abs(c = 1.0 + aa / c) < fpmin) {
                c = fpmin;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) <= eps) {
                return symmetryTransformation ? 1.0 - bt * h / a : bt * h / a;
            }
            ++m;
            m2 += 2;
        }
        return symmetryTransformation ? 1.0 - bt * h / a : bt * h / a;
    }

    private static final double halleyIteration(double x, double wInitial, int maxIter) {
        double w = wInitial;
        double tol = 1.0;
        double t = 0.0;
        for (int i = 0; i < maxIter; ++i) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            double e = Math.exp(w);
            double p = w + 1.0;
            t = w * e - x;
            t = w > 0.0 ? t / p / e : (t /= e * p - 0.5 * (p + 1.0) * t / p);
            tol = 2.220446049250313E-16 * Math.max(Math.abs(w -= t), 1.0 / (Math.abs(p) * e));
            if (!(Math.abs(t) < tol)) continue;
            return w;
        }
        double perc = Math.abs(t / tol);
        if (perc >= 0.5 && perc <= 1.5) {
            return w;
        }
        return Double.NaN;
    }

    private static final double seriesEval(double r) {
        double t8 = Coefficients.lambertWqNearZero[8] + r * (Coefficients.lambertWqNearZero[9] + r * (Coefficients.lambertWqNearZero[10] + r * Coefficients.lambertWqNearZero[11]));
        double t5 = Coefficients.lambertWqNearZero[5] + r * (Coefficients.lambertWqNearZero[6] + r * (Coefficients.lambertWqNearZero[7] + r * t8));
        double t1 = Coefficients.lambertWqNearZero[1] + r * (Coefficients.lambertWqNearZero[2] + r * (Coefficients.lambertWqNearZero[3] + r * (Coefficients.lambertWqNearZero[4] + r * t5)));
        return Coefficients.lambertWqNearZero[0] + r * t1;
    }

    private static final double lambertW0(double x) {
        double w;
        if (Math.abs(x) <= 1.0E-14) {
            return 0.0;
        }
        if (Math.abs(x + 0.36787944117144233) <= 1.0E-14) {
            return -1.0;
        }
        if (Math.abs(x - 1.0) <= 1.0E-14) {
            return 0.5671432904097838;
        }
        if (Math.abs(x - Math.E) <= 1.0E-14) {
            return 1.0;
        }
        if (Math.abs(x + MathConstants.LN_SQRT2) <= 1.0E-14) {
            return -2.0 * MathConstants.LN_SQRT2;
        }
        if (x < -0.36787944117144233) {
            return Double.NaN;
        }
        double q = x + 0.36787944117144233;
        if (q < 0.001) {
            return SpecialFunctions.seriesEval(Math.sqrt(q));
        }
        int MAX_ITER = 100;
        if (x < 1.0) {
            double p = Math.sqrt(5.43656365691809 * q);
            w = -1.0 + p * (1.0 + p * (-0.3333333333333333 + p * 11.0 / 72.0));
        } else {
            w = Math.log(x);
            if (x > 3.0) {
                w -= Math.log(w);
            }
        }
        return SpecialFunctions.halleyIteration(x, w, 100);
    }

    private static final double lambertW1(double x) {
        if (x >= -1.0E-14) {
            return Double.NaN;
        }
        if (x < -0.36787944117144233) {
            return Double.NaN;
        }
        if (Math.abs(x + 0.36787944117144233) <= 1.0E-14) {
            return -1.0;
        }
        double M1 = 0.3361;
        double M2 = -0.0042;
        double M3 = -0.0201;
        double s = -1.0 - Math.log(-x);
        return -1.0 - s - 2.0 / M1 * (1.0 - 1.0 / (1.0 + M1 * Math.sqrt(s / 2.0) / (1.0 + M2 * s * Math.exp(M3 * Math.sqrt(s)))));
    }

    public static final double lambertW(double x, double branch) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(branch)) {
            return Double.NaN;
        }
        if (Math.abs(branch) <= 1.0E-14) {
            return SpecialFunctions.lambertW0(x);
        }
        if (Math.abs(branch + 1.0) <= 1.0E-14) {
            return SpecialFunctions.lambertW1(x);
        }
        return Double.NaN;
    }
}

